function [z relief] = sol2D(r,Lr,K,Sc,prps,U)

% axisymmetric analytic solution to Roering nonlinear diffusion equation
% x=0 is the divide (z=0, dz/dr=0)

L = K*Sc/(2*U*prps);

z = 2*L*Sc*(1 - log(2) - sqrt(1+(r/2/L).^2) + log(1 + sqrt(1+(r/2/L).^2)));

zLr = 2*L*Sc*(1 - log(2) - sqrt(1+(Lr/2/L)^2) + log(1 + sqrt(1+(Lr/2/L)^2)));

z = z - zLr;

relief = -zLr;