% example_Fig3.m

load parameters
p.dt = 100000;
z = imp2D(p);

% compare with analytic solution
x = (0:p.dx:p.Lx);
y = (0:p.dy:p.Ly);
rad=min(p.Lx,p.Ly)/2;
[xm ym] = meshgrid(x,y);
xc=mean(x); yc=mean(y);
r=sqrt((xm-xc).^2 + (ym-yc).^2);
zan = sol2D(r,rad,p.K,p.Sc,p.prps,p.U);

figure
imagesc(z-zan); axis image; colorbar
title('(Numerical solution) - (analytic solution)')