function z = rpk07(x,K,Sc,prps,U)

% analytic solution to nonlinear diffusion equation from Roering, Perron &
% Kirchner (EPSL, 2007).
% x = 0 is the divide (dz/dx = 0), and z(x=0) = 0

sqt = sqrt(1 + (2*prps*U*x/(K*Sc)).^2);
z = (K*Sc^2)/(2*prps*U) * ( log(0.5*(sqt + 1)) - sqt + 1);
