function z = nld1D(z0,p)

% z = nld1D(z0,p)
%
% Calculates finite-difference solution to nonlinear hillslope diffusion
% equation using implicit method described in Perron (2011)

%% set up grid

N = round(p.T/p.dt); % number of iterations to do
x = (0:p.dx:p.L)';   % x coordinates
z = z0;
p.J = length(x);


%% set up plot

v = 1; % vertical exaggeration

if p.doplot
    figure
    plot(x,z0,'b')
    title('n = 0 , t = 0')
end

%% time iteration loop

t = 0;

for n = 1:N
       
    t = t + p.dt;
        
    % update elevations using implicit method
    z = IMP(z,p); 
    
    % update plot
    if p.doplot
        plot(x,z,'b')
        ylim([0 p.L/v])
        title(['n = ' num2str(n) ' , t = ' num2str(t)])
        drawnow
    end
    
end
