function [f F] = getfF(z,p)

dx=p.dx;
J=p.J;
% bdy=(p.bdy==1); % the current version does not respect the bdy vector
a=p.K/p.prps;
b=1/(p.Sc*p.Sc);
U=p.U;

f=zeros(J,1);
F=zeros(J,3);

% create arrays of the functions f and F in equation 23
% column 1 is left-hand neighbor (j-1), column 2 is right-hand neighbor
% (j+1), column 3 is j

for c=1:J
    if c>1 && c<J % don't go off boundaries. Boundary cells have zero f and F in this version, such that z^n+1 = z^n
        zp1=z(c+1);
        zm1=z(c-1);
        z1 = 0.5*(zp1-zm1)/dx;
        z2 = (zp1-2*z(c)+zm1)/dx^2;
        f(c) = U + a*z2/(1-b*z1^2)*(1+2*b*z1^2/(1-b*z1^2));
        F(c,1)=a/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)*(1+1/2*b*(zp1-zm1)^2/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2))-1/2*a*(zp1-2*z(c)+zm1)/dx^4/(1-1/4*b*(zp1-zm1)^2/dx^2)^2*(1+1/2*b*(zp1-zm1)^2/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2))*b*(zp1-zm1)+a*(zp1-2*z(c)+zm1)/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)*(-b*(zp1-zm1)/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)-1/4*b^2*(zp1-zm1)^3/dx^4/(1-1/4*b*(zp1-zm1)^2/dx^2)^2);
        F(c,2)=a/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)*(1+1/2*b*(zp1-zm1)^2/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2))+1/2*a*(zp1-2*z(c)+zm1)/dx^4/(1-1/4*b*(zp1-zm1)^2/dx^2)^2*(1+1/2*b*(zp1-zm1)^2/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2))*b*(zp1-zm1)+a*(zp1-2*z(c)+zm1)/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)*(b*(zp1-zm1)/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)+1/4*b^2*(zp1-zm1)^3/dx^4/(1-1/4*b*(zp1-zm1)^2/dx^2)^2);
        F(c,3)=-2*a/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2)*(1+1/2*b*(zp1-zm1)^2/dx^2/(1-1/4*b*(zp1-zm1)^2/dx^2));
    end
end
