% example_Fig2.m

%% set parameters 
p.dx = 2;       % delta x (m)
p.dt = 10000;   % delta t (yr)
p.L = 300;        % length of grid (m)
p.T = 3e6;        % total run time (yr)
p.U = 1e-4;     % uplift rate (m/yr)
p.K = 0.005;    % transport coefficient (m^2/yr)
p.Sc = 1.25;    % critical gradient (m/m)
p.prps = 2.0;   % rho_rock/rho_soil
p.doplot = 1;   % 1 to make plots, 0 not

x = (0:p.dx:p.L)';  % x coordinates

%% initial conditions

z0 = zeros(size(x));
                           

%% boundary conditions

% points marked 1 experience no uplift or erosion; points marked zero do.
% Note, however, that the included version of getfF.m, which calculates the
% right-hand side of the finite-difference approximation and its partial
% derivatives (f and F in the paper) does not respect this boundary
% condition array -- fixed left and right boundaries are hard-coded. This
% could be fixed with some modest changes to the code.

p.bdy = zeros(size(x));
p.bdy([1 end]) = 1; % 1 at boundaries, zero elsewhere


%% run the model

z = nld1D(z0,p);


%% plot analytic solution from Roering, Perron & Kirchner 2007

if p.doplot

    zan = rpk07(x-mean(x),p.K,p.Sc,p.prps,p.U);
    zan = zan - min(zan); 
    hold on
    plot(x,zan,'--r');

end