function [A B] = BuildMats(z,p,f,F)

dt=p.dt;
J=p.J;

% % RHS vector (present time). Add first two terms here. The full expression is 
% % B = z + dt*(f + sum(Fd)*(z - z_d) + sum(Fr)*(z - z_r))
% % we'll do the rest in the loop below

B = zeros(J,1);

% matrix that operates on future time. This will give us the quantity
% (1 + dt*sum(Fd) + dt*sum(Fr))*z_i^n+1 
%  - dt*sum(Fd)*z_d^n+1 
%  - dt*sum(Fr)*z_r^n+1
A = sparse(J);

di = [-1 1]; % vector, and matrix column, offset for each neighbor [L R]

for i=1:J % for each elevation
    % diagonal elements of A
    A(i,i) = 1 - dt*F(i,3);
    
    % first 2 terms of B
    B(i) = (1 - dt*F(i,3))*z(i) + dt*f(i);
    
    for n=1:2 % loop through neighbors
        
        in = i + di(n); % vector and matrix column index of neighbor element

        if (in>0 && in<J+1) % don't go off boundaries
        
            % off-diagonal elements of A
            A(i,in) = -dt*F(i,n);

            % neighbor terms of B
            B(i) = B(i) - dt*F(i,n)*z(in);

        end
    end
end
